<?php

add_filter( 'x_enqueue_parent_stylesheet', '__return_true' );

function enqueuescripts() {
	wp_enqueue_script('lightbox', get_stylesheet_directory_uri().'/lightbox.js', array('jquery'));
	wp_enqueue_script('ajaxloadpost', get_stylesheet_directory_uri().'/gallery.js', array('jquery'));
	wp_localize_script('ajaxloadpost', 'ajax_postajax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));
}

add_action('wp_enqueue_scripts', enqueuescripts);

add_action('wp_ajax_nopriv_ajax_all_categories', 'get_all_filter_categories');
add_action('wp_ajax_ajax_all_categories', 'get_all_filter_categories');


function get_all_filter_categories() {
	$categories = array();
	/* get_categories(array( 
		'taxonomy' => 'portfolio-category',
		'hide_empty' => false
	));
	*/
	$cat_gamme_id  = get_category_id("Gamme");
	$cat_modele_id = get_category_id("Modele");
	$cat_marque_id = get_category_id("Marque");
	
	$categories['gamme'] = array(
		'name' => 'Gamme',
		'categories' => get_categories_by_parent($cat_gamme_id)
	);
	
	$categories['modele'] = array(
		'name' => 'Modèle',
		'categories' => get_categories_by_parent($cat_modele_id)
	);
	
	$categories['marque'] = array(
		'name' => 'Marque',
		'categories' => get_categories_by_parent($cat_marque_id)
	);
	echo json_encode($categories);
	die();
}

function get_categories_by_parent($parent_id) {
	return get_categories( array(
			'taxonomy' => 'portfolio-category',
			'hide_empty' => false,
			'parent' => $parent_id
		));
}
function get_category_id($name){
	$cat_id = get_term_by('name', $name, 'portfolio-category')->term_id;
	return $cat_id;
}

add_filter('upload_mimes', 'add_custom_upload_mimes');
    function add_custom_upload_mimes($existing_mimes) {
    	$existing_mimes['otf'] = 'application/x-font-otf';
    	$existing_mimes['ttf'] = 'application/x-font-ttf';
    	$existing_mimes['eot'] = 'application/vnd.ms-fontobject';
        $existing_mimes['woff'] = 'font/woff';
        $existing_mimes['woff2'] = 'font/woff2';
    	return $existing_mimes;
    }

    function font_mime_types($mimes) {
      $mimes['svg'] = 'image/svg+xml';
      $mimes['woff'] = 'font/woff';
      $mimes['woff2'] = 'font/woff2';
      return $mimes;
    }
    add_filter('upload_mimes', 'font_mime_types');